//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
#property description "DEMO Indicator"
//+------------------------------------------------------------------+
const struct stAverange
{
    int            nPeriods;
    ENUM_MA_METHOD Method;
    color          cor;
}Averange[] = 
{
    {20, MODE_SMA, clrDodgerBlue}
};
//+----------------+
#property indicator_chart_window
#property indicator_applied_price   PRICE_CLOSE
#property indicator_buffers         Averange.Size();
#property indicator_plots           Averange.Size();
//+------------------------------------------------------------------+
struct stInfos
{
    double  Buff_iMA[],
            f_Expo;
}Infos[Averange.Size()];
//+------------------------------------------------------------------+
int OnInit(void)
{
    for (uint c = 0; c < Averange.Size(); c++)
    {
        SetIndexBuffer(c, Infos[c].Buff_iMA, INDICATOR_DATA);
        Infos[c].f_Expo = (double) (2.0 / (1.0 + Averange[c].nPeriods));
        PlotIndexSetInteger(c, PLOT_DRAW_TYPE, DRAW_LINE);
        PlotIndexSetInteger(c, PLOT_LINE_STYLE, STYLE_SOLID);
        PlotIndexSetInteger(c, PLOT_LINE_WIDTH, 2);
        PlotIndexSetInteger(c, PLOT_LINE_COLOR, Averange[c].cor);
        PlotIndexSetString(c, PLOT_LABEL, StringFormat("%s of %d", (Averange[c].Method == MODE_EMA ? "Exponential" : "Arithmetica"), Averange[c].nPeriods));
    }

       return INIT_SUCCEEDED;
};
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total, const int prev_calculated, const int begin, const double &price[])
{
    int c0 = 0;
    double value;

    for (uint c = 0; c < Averange.Size(); c++) switch (Averange[c].Method)
    {
        case MODE_SMA:
            for (int i = rates_total - 1; i > prev_calculated; i--)
            {
                value = 0;
                for (int j = 0; (i - j) > 0 && j < Averange[c].nPeriods; j++)
                    value += price[i - j];
                Infos[c].Buff_iMA[i] = value / Averange[c].nPeriods;
            }
            break;
    }

    return rates_total;
};
//+------------------------------------------------------------------+